<?php
/**
 * @package       RSMembership!
 * @plugin RSMembership Sepal Payment
 * @copyright (C) 2021 www.sepal.ir
 * @license       GPL, http://www.gnu.org/licenses/gpl-2.0.html
 */

defined('_JEXEC') or die('Restricted access');
require_once JPATH_ADMINISTRATOR . '/components/com_rsmembership/helpers/rsmembership.php';

class plgSystemRSMembershipSepal extends JPlugin
{
    public function __construct(&$subject, $config)
    {
        parent::__construct($subject, $config);
        // load languages
        $this->loadLanguage('plg_system_rsmembership', JPATH_ADMINISTRATOR);
        $this->loadLanguage('plg_system_rsmembershipsepal', JPATH_ADMINISTRATOR);

        RSMembership::addPlugin( $this->translate('OPTION_NAME'), 'rsmembershipsepal');
    }

    /**
     * call when payment starts
     *
     * @param $plugin
     * @param $data
     * @param $extra
     * @param $membership
     * @param $transaction
     * @param $html
     */
    public function onMembershipPayment($plugin, $data, $extra, $membership, $transaction, $html)
    {
        $app = JFactory::getApplication();

        try {
            if ($plugin != 'rsmembershipsepal')
                return;

            $api_key     = trim($this->params->get('api_key'));
            $extra_total = 0;
            foreach ($extra as $row) {
                $extra_total += $row->price;
            }

            $amount = $transaction->price + $extra_total;
            $amount *= $this->params->get('currency') == 'rial' ? 1 : 10;

            $transaction->custom = md5($transaction->params . ' ' . time());
            if ($membership->activation == 2) {
                $transaction->status = 'completed';
            }
            $transaction->store();

            $callback = JURI::base() . 'index.php?option=com_rsmembership&sepalPayment=1&invoiceNumber='. $transaction->id;
            $callback = JRoute::_($callback, false);
            $session  = JFactory::getSession();
            $session->set('transaction_custom', $transaction->custom);
            $session->set('membership_id', $membership->id);

            $data = [
                'apiKey'		=> $api_key,
                'amount'		=> $amount,
                'callbackUrl'	=> $callback,
                'payerName'		=> !empty($data->fields['name'])? $data->fields['name'] : '',
                'payerEmail'	=> !empty($data->fields['email'])? $data->fields['email'] : '',
                'payerMobile'	=> !empty($data->fields['phone'])? $data->fields['phone'] : '',
                'invoiceNumber'	=> $transaction->id,
                'description'	=> htmlentities( $this->translate('PARAMS_DESC') . $transaction->id, ENT_COMPAT, 'utf-8'),
            ];

            $ch = curl_init();
            curl_setopt( $ch, CURLOPT_URL, 'https://sepal.ir/api/request.json' );
            curl_setopt( $ch, CURLOPT_POSTFIELDS, json_encode( $data ) );
            curl_setopt( $ch, CURLOPT_POST,true);
		    curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false);
		    curl_setopt( $ch, CURLOPT_SSL_VERIFYHOST, false);
		    curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true);
		    curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt( $ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
            $result      = curl_exec( $ch );
            $result      = json_decode( $result );
            $http_status = curl_getinfo( $ch, CURLINFO_HTTP_CODE );
            curl_close( $ch );

            if ( $http_status != 200 || empty( $result ) || empty( $result->paymentNumber ) || ( !$result->status ) )
            {
                $transaction->status = 'denied';
                $transaction->store();

                RSMembership::saveTransactionLog($result->message, $transaction->id);
                throw new Exception($result->message);
            }

            RSMembership::saveTransactionLog( $this->translate('LOG_GOTO_BANK'), $transaction->id );
            $app->redirect('https://sepal.ir/payment/' . $result->paymentNumber);

            exit;
        }
        catch (Exception $e) {
            $app->redirect(JRoute::_(JURI::base() . 'index.php/component/rsmembership/view-membership-details/' . $membership->id, false), $e->getMessage(), 'error');
            exit;
        }
    }

    public function getLimitations() {
        $msg = $this->translate('LIMITAION');
        return $msg;
    }

    /**
     * after payment completed
     * calls function onPaymentNotification()
     */
    public function onAfterDispatch()
    {
        $app = JFactory::getApplication();
        if ($app->input->getBoolean('sepalPayment')) {
            $this->onPaymentNotification($app);
        }
    }

    /**
     * process payment verification and approve subscription
     * @param $app
     */
    protected function onPaymentNotification($app)
    {
        $input			= $app->input;
        $status			= empty( $input->get->get( 'status' ) ) ? NULL : $input->get->get( 'status' );
        $paymentNumber	= empty( $input->get->get( 'paymentNumber' ) ) ? NULL : $input->get->get( 'paymentNumber' );
        $order_id		= empty( $input->get->get( 'invoiceNumber' ) ) ? NULL : $input->get->get( 'invoiceNumber' );

        $session  = JFactory::getSession();
        $transaction_custom = $session->get('transaction_custom');

        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select('*')
            ->from($db->quoteName('#__rsmembership_transactions'))
            ->where($db->quoteName('status') . ' != ' . $db->quote('completed'))
            ->where($db->quoteName('custom') . ' = ' . $db->quote($transaction_custom));
        $db->setQuery($query);
        $transaction = @$db->loadObject();

        try {
            if ( empty( $paymentNumber ) || empty( $order_id ) )
                throw new Exception( $this->translate('ERROR_EMPTY_PARAMS') );

            if (!$transaction)
                throw new Exception( $this->translate('ERROR_NOT_FOUND') );

            // Check double spending.
            if ( $transaction->id != $order_id )
                throw new Exception( $this->translate('ERROR_WRONG_PARAMS') );

            if ( $status != 1 )
                throw new Exception( $this->translate('ERROR_CANCELED') );

            $api_key = $this->params->get( 'api_key', '' );
            $data = [
                'paymentNumber'	=> $paymentNumber,
                'apiKey'		=> $api_key,
            ];
            $ch = curl_init();
            curl_setopt( $ch, CURLOPT_URL, 'https://sepal.ir/api/verify.json' );
            curl_setopt( $ch, CURLOPT_POSTFIELDS, json_encode( $data ) );
            curl_setopt( $ch, CURLOPT_POST,true);
		    curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false);
		    curl_setopt( $ch, CURLOPT_SSL_VERIFYHOST, false);
		    curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true);
		    curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt( $ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
            $result      = curl_exec( $ch );
            $result      = json_decode( $result );
            $http_status = curl_getinfo( $ch, CURLINFO_HTTP_CODE );
            curl_close( $ch );

            if ( $http_status != 200 || ( !$result->status ) ) {
                $msg = $this->translate('ERROR_FAILED_VERIFY') . ' ' . $result->message;
                throw new Exception($msg);
            }

            if ( $result->status ) {
                $query->clear();
                $query->update($db->quoteName('#__rsmembership_transactions'))
                    ->set($db->quoteName('hash') . ' = ' . $db->quote($paymentNumber))
                    ->where($db->quoteName('id') . ' = ' . $db->quote($transaction->id));

                $db->setQuery($query);
                $db->execute();

                $membership_id = $session->get('membership_id');

                if (!$membership_id)
                    throw new Exception( $this->translate('ERROR_NOT_FOUND'));

                $query->clear()
                    ->select('activation')
                    ->from($db->quoteName('#__rsmembership_memberships'))
                    ->where($db->quoteName('id') . ' = ' . $db->quote((int)$membership_id));
                $db->setQuery($query);
                $activation = $db->loadResult();

                if ($activation) {// activation == 0 => activation is manual
                    RSMembership::finalize($transaction->id);
                    RSMembership::approve($transaction->id);
                }

                $msg = $this->sepal_get_filled_message( $paymentNumber, $transaction->id, 'success_massage' );
                RSMembership::saveTransactionLog($msg, $transaction->id);

                $app->redirect(JRoute::_(JURI::base() . 'index.php?option=com_rsmembership&task=thankyou', false), $msg, 'message');
                //$app->redirect(JRoute::_(JURI::base() . 'index.php?option=com_rsmembership&view=mymemberships', false), $msg, 'message');
            }

            $msg = $this->sepal_get_filled_message( $paymentNumber, $transaction->id, 'failed_massage' );
            throw new Exception($msg);

        } catch (Exception $e) {
            if($transaction){
                RSMembership::deny($transaction->id);
                RSMembership::saveTransactionLog($e->getMessage(), $transaction->id );
            }
            $app->enqueueMessage($e->getMessage(), 'error');
        }
    }

    /**
     * fill message in gateway setting with ref_num and order_id
     *
     * @param $ref_num
     * @param $order_id
     * @param $type | success or error
     *
     * @return String
     */
    public function sepal_get_filled_message( $ref_num, $order_id, $type ) {
        return str_replace( [ "{ref_num}", "{order_id}" ], [
            $ref_num,
            $order_id,
        ], $this->params->get( $type, '' ) );
    }

    /**
     * translate plugin language files
     * @param $key
     * @return mixed
     */
    protected function translate($key)
    {
        return JText::_('PLG_RSM_SEPAL_' . strtoupper($key));
    }
}