<?
/*
  Virtual Freer
  http://freer.ir/virtual
  https://sepal.ir
*/

/****************** sepal Class ******************/
class SepalGateWay{

	private $apiUrl = 'https://sepal.ir/api';
	private $gatewayUrl = 'https://sepal.ir/payment';

	public function paymentRequest($params){
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $this->apiUrl.'/request.json');
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
		curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($params));
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		$response = json_decode(curl_exec($curl));
		curl_close($curl);
		if(isset($response->status) && $response->status == 1 ){
			return array(
				'status'    		=>  true,
				'paymentNumber'     =>  $response->paymentNumber,
			);
		}else{
			return array(
				'status'    =>  false,
				'message'   =>  $response->message,
			);
		}
	}

	public function paymentVerify($params){
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $this->apiUrl.'/verify.json');
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
		curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode( $params ));
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		$response = json_decode(curl_exec($curl));
		curl_close($curl);
		if(isset($response->status) && $response->status == 1){
			return array(
				'status'    =>  true,
			);
		}else{
			return array(
				'status'    =>  false,
				'message'   =>  $response->message,
			);
		}
	}

	public function paymentGateway($paymentNumber){
		$paymentUrl = $this->gatewayUrl.'/'.$paymentNumber;
		if ( ! headers_sent() ) {
			header('Location: ' . $paymentUrl );
			die;
		}
		die('<script type="text/javascript">window.location="' .$paymentUrl. '";</script>');
	}

	public function getGatewayUrl(){
		return $this->gatewayUrl;
	}

}

//-- اطلاعات کلی پلاگین
$pluginData[sepal][type] = 'payment';
$pluginData[sepal][name] = 'سپال';
$pluginData[sepal][uniq] = 'sepal';
$pluginData[sepal][description] = 'پرداخت با درگاه <a href="https://sepal.ir">سپال</a>';
$pluginData[sepal][author][name] = 'سپال';
$pluginData[sepal][author][url] = 'https://sepal.ir';
$pluginData[sepal][author][email] = 'support@sepal.ir';

//-- فیلدهای تنظیمات پلاگین
$pluginData[sepal][field][config][1][title] = 'کلید وب سرویس';
$pluginData[sepal][field][config][1][name] = 'apiKey';

//-- تابع انتقال به دروازه پرداخت
function gateway__sepal($data)
{
	global $config,$db,$smarty;
	$apiKey 		= trim($data['apiKey']);
	$amount 		= round($data['amount']);
	$invoice_id		= $data['invoice_id'];
	$callBackUrl 	= $data['callback'];

	$sql 		= 'SELECT * FROM `payment` WHERE `payment_rand` = "'.$invoice_id.'" LIMIT 1;';
	$payment 	= $db->fetch($sql);

	$gateway = new SepalGateWay();
	$params = array(
		'apiKey' 		=> 	$apiKey,
		'amount' 		=> 	$amount,
		'callbackUrl' 	=> 	$callBackUrl,
		'invoiceNumber' => 	$invoice_id,
		'payerName'		=>	'',
		'payerEmail'	=>	$payment['payment_email'],
		'payerMobile'	=>	$payment['payment_mobile'],
	);
	$request = $gateway->paymentRequest($params);

	if ($request['status'])
	{
		
		$update['payment_rand'] = $request['paymentNumber'];
		$sql = $db->queryUpdate('payment', $update, 'WHERE `payment_rand` = "'.$invoice_id.'" LIMIT 1;');
		$db->execute($sql);
		
		$gateway->paymentGateway($request['paymentNumber']);
		exit;
	}
	else
	{
		$data['title'] = 'خطای سیستم';
		$data['message'] = '<div style="color:red;">در اتصال به درگاه پرداخت مشکلی به وجود آمد٬ لطفا از سایر درگاه ها استفاده نمایید.</div>'.$request['message'].'<br /><a href="index.php" class="button">بازگشت</a>';
		$query	= 'SELECT * FROM `config` WHERE `config_id` = "1" LIMIT 1';
		$conf	= $db->fetch($query);
		$smarty->assign('config', $conf);
		$smarty->assign('data', $data);
		$smarty->display('message.tpl');
	}
}

//-- تابع بررسی وضعیت پرداخت
function callback__sepal($data)
{
	global $db;

	$invoiceNumber = isset($_POST['invoiceNumber']) ? $_POST['invoiceNumber'] : '';
	$paymentNumber = isset($_POST['paymentNumber']) ? $_POST['paymentNumber'] : '';

	if (isset($_POST['status']) && $_POST['status'] == 1)
	{
		$apiKey = $data['apiKey'];
		$sql 		= 'SELECT * FROM `payment` WHERE `payment_rand` = "'.$paymentNumber.'" LIMIT 1;';
		$payment 	= $db->fetch($sql);

		if ($payment['payment_status'] == 1)
		{
			$gateway = new SepalGateWay();
			$params = array(
				'apiKey' => $apiKey,
				'paymentNumber' => $paymentNumber,
			);
			$request = $gateway->paymentVerify($params);
			if ($request['status'])//-- موفقیت آمیز
			{
				$update['payment_rand'] = $request['referenceNumber'];
				$sql = $db->queryUpdate('payment', $update, 'WHERE `payment_rand` = "'.$paymentNumber.'" LIMIT 1;');
				$db->execute($sql);
				
				//-- آماده کردن خروجی
				$output['status']		= 1;
				$output['res_num']	= $invoiceNumber;
				$output['ref_num']	= $paymentNumber;
				$output['payment_id']	= $payment['payment_id'];
			}
			else
			{
				//-- در تایید پرداخت مشکلی به‌وجود آمده است‌
				$output['status']	= 0;
				$output['message']= 'پرداخت توسط درگاه پرداخت تایید نشد‌.'.$request['message'];
			}
		}
		else
		{
			//-- قبلا پرداخت شده است‌
			$output['status']	= 0;
			$output['message']= 'سفارش قبلا پرداخت شده است.';
		}
	}
	else
	{
			//-- پرداخت انجام نشده است
			$output['status']	= 0;
			$output['message']= 'پرداخت انجام نشد';
	}
	return $output;
}
