<?php

class sepal extends PaymentModule
{

    private $_html = '';
    private $_postErrors = [];

    public function __construct()
    {

        $this->name = 'sepal';
        $this->tab = 'payments_gateways';
        $this->version = '1.0';
        $this->author = 'sepal.ir';

        $this->currencies = true;
        $this->currencies_mode = 'radio';

        parent::__construct();

        $this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('درگاه پرداخت sepal');
        $this->description = $this->l('ماژول درگاه پرداخت sepal');
        $this->confirmUninstall = $this->l('Are you sure, you want to delete your details?');

        if (!sizeof(Currency::checkPaymentCurrencies($this->id)))
            $this->warning = $this->l('No currency has been set for this module');

        $config = Configuration::getMultiple(['SEPAL_APIKEY', '']);
        if (!isset($config['SEPAL_APIKEY']))
            $this->warning = $this->l('Your Sepal APIKEY Code must be configured in order to use this module');


        if ($_SERVER['SERVER_NAME'] == 'localhost')
            $this->warning = $this->l('Your are in localhost, sepal Payment can\'t validate order');


    }

    public function install()
    {
        if (!parent::install()
            OR !Configuration::updateValue('SEPAL_APIKEY', '')
            OR !$this->registerHook('payment')
            OR !$this->registerHook('paymentReturn')
        ) {
            return false;
        } else {
            return true;
        }
    }

    public function uninstall()
    {
        if (!Configuration::deleteByName('SEPAL_APIKEY')
            OR !parent::uninstall()
        )
            return false;

        return true;
    }

    public function displayFormSettings()
    {
        $this->_html .= '
        <form action="' . $_SERVER['REQUEST_URI'] . '" method="post">
            <fieldset>
                <legend><img src="../img/admin/cog.gif" alt="" class="middle" />' . $this->l('Settings') . '</legend>
                <label>' . $this->l('Sepal API') . '</label>
                <div class="margin-form"><input type="text" size="30" name="SepalAPIKEY" value="' . Configuration::get('SEPAL_APIKEY') . '" /></div>
                <p class="hint clear" style="display: block; width: 501px;">' . $this->l('This hash key should be a secret code for your site.(Please combine an string contain your site name and a date string)') . '</p></div>
                <center><input type="submit" name="submitPay" value="' . $this->l('Update Settings') . '" class="button" /></center>
            </fieldset>
        </form>';
    }

    public function displayConf()
    {
        $this->_html .= '
        <div class="conf confirm">
            <img src="../img/admin/ok.gif" alt="' . $this->l('Confirmation') . '" />
            ' . $this->l('Settings updated') . '
        </div>';
    }

    public function displayErrors()
    {
        foreach ($this->_postErrors AS $err)
            $this->_html .= '<div class="alert error">' . $err . '</div>';
    }

    public function getContent()
    {
        $this->_html = '<h2>' . $this->l('sepal Payment') . '</h2>';
        if (isset($_POST['submitPay'])) {
            if (empty($_POST['SepalAPIKEY']))
                $this->_postErrors[] = $this->l('sepal API is required.');
            if (!sizeof($this->_postErrors)) {
                Configuration::updateValue('SEPAL_APIKEY', $_POST['SepalAPIKEY']);
                $this->displayConf();
            } else
                $this->displayErrors();
        }

        $this->displayFormSettings();

        return $this->_html;
    }

    private function displaysepal()
    {
        $this->_html .= 'درگاه پرداخت sepal<b>' . $this->l('This module allows you to accept payments by sepal.') . '</b><br /><br />
        ' . $this->l('Any cart from Shetab Banks are accepted.') . '<br /><br /><br />';

    }

    public function execPayment($cart)
    {
        include('sender.php');
        global $cookie, $smarty;

        include_once("sender.php");
        $api = Configuration::get('SEPAL_APIKEY');
        $purchase_currency = $this->GetCurrency();
        $OrderDesc = Configuration::get('PS_SHOP_NAME') . $this->l(' Order');
        $amount = number_format($cart->getOrderTotal(true, 3), 0, '', '');
        if($this->GetCurrency()->iso_code == 'IRT' || $this->GetCurrency()->sign == 'تومان'){
            $amount = $amount * 10;
        }
        $OrderId = (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . __PS_BASE_URI__ . 'modules/sepal/validation.php';
        // $OrderId = intval($OrderId) - 1;
        $redirect = (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . __PS_BASE_URI__ . 'modules/sepal/validation.php';

        $result = send($api, $amount, $cart->id, $redirect);

        if ($result->status) {
            setcookie("OrderId", $cart->id, time() + 1800);
            setcookie("PurchaseAmount", $amount, time() + 1800);
            $go = 'https://sepal.ir/payment/' . $result->paymentNumber;
            Tools::redirectLink($go);
            return 'در حال اتصال . لطفا صبر کنید...';
        } else {
            return $result->message;
        }
    }

    public function confirmPayment()
    {
        include('sender.php');

        if ($_POST['status'] == 1)
        {
            $api = Configuration::get('SEPAL_APIKEY');
            return verify($api, $_POST['paymentNumber']);
        }
        else
        {
            return array('status' => false, 'message' => 'تراکنش توسط کاربر لغو شد');
        }
    }

    public function showMessages($result)
    {
        $this->_postErrors[] = $this->l($result->errorMessage);
        $this->displayErrors();
        echo $this->_html;

        return $result;
    }

    public function hookPayment($params)
    {
        if (!$this->active)
            return;

        return $this->display(__FILE__, 'payment.tpl');
    }

    public function hookPaymentReturn($params)
    {
        echo 1;
        if (!$this->active)
            return;

        return $this->display(__FILE__, 'confirmation.tpl');
    }

}
