<?php

if (!isset($percheck) || empty($percheck) || $percheck != 'vipsystem') { die('Access Denied'); }

// This Data Only For Install
function plugin_data()
{
	return array(
		"type" 			=> "payment",
		"name_fa" 		=> "پرداخت با سپال",
		"name_en" 		=> "Payment Via example Gateway",
		"merchant_key" 	=> "exampleMerchantKey",
		"merchant_pass" => "exampleMerchantPassword",
		"sandbox" 		=> 0,
	);
}


	function paymentRequest($params){

		$apiUrl = 'https://sepal.ir/api';
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $apiUrl.'/request.json');
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($params));
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $response = json_decode(curl_exec($curl));
        curl_close($curl);
        if(isset($response->status) && $response->status == 1 ){
            return array(
                'status'    		=>  true,
                'paymentNumber'     =>  $response->paymentNumber,
            );
        }else{
            return array(
                'status'    =>  false,
                'message'   =>  $response->message,
            );
        }
    }

    function paymentVerify($params){
		$apiUrl = 'https://sepal.ir/api';
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $apiUrl.'/verify.json');
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode( $params ));
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $response = json_decode(curl_exec($curl));
        curl_close($curl);
        if(isset($response->status) && $response->status == 1){
            return array(
                'status'    =>  true,
            );
        }else{
            return array(
                'status'    =>  false,
                'message'   =>  $response->message,
            );
        }
    }


    function paymentGateway($paymentNumber){
			
		$gatewayUrl = 'https://sepal.ir/payment';
        $paymentUrl = $gatewayUrl.'/'.$paymentNumber;
        if ( ! headers_sent() ) {
            header('Location: ' . $paymentUrl );
            die;
        }
        die('<script type="text/javascript">window.location="' .$paymentUrl. '";</script>');
    }	



function payment_start($id, $price, $usd)
{
	
    global $CONF, $lang, $site;

	$merchant_key 	= $site->plugin('example', 'merchant_key'); 	// Merchant Key ( Get From plugin_data / Setting )
	$merchant_pass 	= $site->plugin('example', 'merchant_pass'); 	// Merchant Password ( Get From plugin_data / Setting )
    $callback     = $CONF['site_url'] .'/?callback='. $id;     // Callback URL
	// Enter Code for Create Transaction and Get Authority
	$_POST['amount']=$price*10;
	

        $params = array(
            'apiKey' => '................................',
            'amount' => $_POST['amount'],
            'callbackUrl' => $callback,
            'invoiceNumber' => $id,
            'payerName' => $_POST['payer_name'],
            'payerEmail' => $_POST['payer_email'],
            'payerMobile' => $_POST['payer_mobile'],
            'description' => $_POST['description'],
        );
        $request = paymentRequest($params);

        if($request['status']){
	   		// Save Authority to Database
			payment_update_au($id, "شناسه پرداخت");
			// Redirect to Transaction URL
			paymentGateway($request['paymentNumber']);
        }else{
            //$errors[] = $request['message'];
			return msg("Enter Error Code or Message Here", 'danger', $lang['PAYMENT_BOLD']);
        }

}

function payment_verify($id, $price, $usd)
{
    global $CONF, $lang, $site;

	$merchant_key 	= $site->plugin('example', 'merchant_key'); 	// Merchant Key ( Get From plugin_data / Setting )
	$merchant_pass 	= $site->plugin('example', 'merchant_pass'); 	// Merchant Password ( Get From plugin_data / Setting )

	// Enter Code for Check Transaction Status
        $params = array(
            'apiKey' => '...................................',
            'paymentNumber' => $_POST['paymentNumber'],
        );
        $request = paymentVerify($params);
        if($request['status']){
            //$message = 'پرداخت شما با موفقیت انجام شد <br /> شماره پرداخت : '.$_POST['paymentNumber'];
					// Transaction Successful
			return array(
				'status' 		=> 1,
				'id' 			=> $id,
				'callback_ref' 	=> "Transaction Tracking Code",
				'callback_res' 	=> "Transaction Callback Status Code"
			);
			
        }else{
            //$errors[] = $request['message'];
			// Transaction Failed
			return array(
				'status' 		=> 0,
				'id' 			=> 0,
				'callback_ref' 	=> 0,
				'callback_res' 	=> "Transaction Callback Status Code"
			);
        }
		
		
}
?>