<?php



class ControllerExtensionPaymentSepal extends Controller
{
    public function index()
    {

        $this->load->language('extension/payment/sepal');
        $this->load->model('checkout/order');
        $this->load->library('encryption');

        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

        //$encryption = new Encryption($this->config->get('config_encryption'));

        //if ($this->currency->getCode() != 'RLS') {
        //
        //    $this->currency->set('RLS');
        //}

        $data['button_confirm'] = $this->language->get('button_confirm');

        $data['error_warning'] = false;

        $description = 'پرداخت سفارش شناسه ' . $order_info['order_id'];

        if (extension_loaded('curl')) {

            $parameters = [
                 'apiKey'        => $this->config->get('payment_sepal_api'),
                 'amount'        => $this->currency->format($order_info['total'], 'IRR', null, false),
                 'callbackUrl'   => ($this->url->link('extension/payment/sepal/callback', 'order_id=' . $order_info['order_id'])),
                 'invoiceNumber' => $order_info['order_id'],
                 'payerName'     => $order_info['payment_firstname'] . ' ' . $order_info['payment_lastname'],
                 'payerEmail'    => $order_info['email'],
                 'payerMobile'   => $order_info['telephone'],
                 'description'   => $description,
            ];
            $result = $this->common($this->config->get('payment_sepal_send'), $parameters);
            if ($result->status) {

                $data['action'] = $this->config->get('payment_sepal_gateway') . $result->paymentNumber;

            } else {

                $data['error_warning'] = $this->language->get('error_request') . '<br/><br/>' . $this->language->get('error_message') . $result->message;
            }

        } else {

            $data['error_warning'] = $this->language->get('error_curl');
        }

        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/extension/payment/sepal')) {

            return $this->load->view($this->config->get('config_template') . '/extension/payment/sepal', $data);

        } else {

            return $this->load->view('/extension/payment/sepal', $data);
        }
    }



    public function callback()
    {
        ob_start();

        $this->load->language('extension/payment/sepal');
        $this->load->model('checkout/order');
        $this->load->library('encryption');

        $this->document->setTitle($this->language->get('heading_title'));

        //$encryption = new Encryption($this->config->get('config_encryption'));

        $order_id = isset($this->session->data['order_id']) ? $this->session->data['order_id'] : false;
        $order_id = isset($order_id) ? $order_id : $this->request->get['order_id'];

        $order_info = $this->model_checkout_order->getOrder($order_id);

        //if ($this->currency->getCode() != 'RLS') {
        //
        //    $this->currency->set('RLS');
        //}

        $data['heading_title'] = $this->language->get('heading_title');

        $data['button_continue'] = $this->language->get('button_continue');
        $data['continue']        = $this->url->link('common/home', '', 'SSL');

        $data['error_warning'] = false;

        $data['continue'] = $this->url->link('checkout/cart', '', 'SSL');

        if ($this->request->post['status']) {

            $status = $this->request->post['status'];
            $paymentNumber  = $this->request->post['paymentNumber'];
            $invoiceNumber = $this->request->post['invoiceNumber'];

            if ($this->request->post['status'] == 1) {

                $parameters = [
                     'apiKey'        => $this->config->get('payment_sepal_api'),
                     'paymentNumber' => $paymentNumber,
                ];

                $result = $this->common($this->config->get('payment_sepal_verify'), $parameters);

                if ($order_id == $order_info['order_id']) {

                    if (isset($result->status) && $result->status) {

                        //						$amount = @$this->currency->format($order_info['total'], $order_info['currency'], $order_info['value'], false);
                        $amount = $this->currency->format($order_info['total'], 'IRR', null, false) * 10;

                        $comment = $this->language->get('text_transaction') . $paymentNumber;

                        $this->model_checkout_order->addOrderHistory($order_info['order_id'], $this->config->get('payment_sepal_order_status_id'), $comment);

                    } else {

                        $message = $result->message;

                        $data['error_warning'] = $this->language->get('error_request') . '<br/><br/>' . $this->language->get('error_message') . $message;
                    }

                } else {

                    $data['error_warning'] = $this->language->get('error_invoice');
                }

            } else {

                $data['error_warning'] = $this->language->get('error_payment');
            }

        } else {

            $data['error_warning'] = $this->language->get('error_data');
        }

        if ($data['error_warning']) {

            $data['breadcrumbs'] = [];

            $data['breadcrumbs'][] = [
                 'text'      => $this->language->get('text_home'),
                 'href'      => $this->url->link('common/home', '', 'SSL'),
                 'separator' => false,
            ];

            $data['breadcrumbs'][] = [
                 'text'      => $this->language->get('text_basket'),
                 'href'      => $this->url->link('checkout/cart', '', 'SSL'),
                 'separator' => ' » ',
            ];

            $data['breadcrumbs'][] = [
                 'text'      => $this->language->get('text_checkout'),
                 'href'      => $this->url->link('checkout/checkout', '', 'SSL'),
                 'separator' => ' » ',
            ];

            $data['header'] = $this->load->controller('common/header');
            $data['footer'] = $this->load->controller('common/footer');

            if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/extension/payment/sepal_callback')) {

                $this->response->setOutput($this->load->view($this->config->get('config_template') . '/extension/payment/sepal_callback', $data));

            } else {

                $this->response->setOutput($this->load->view('extension/payment/sepal_callback', $data));
            }

        } else {

            $this->response->redirect($this->url->link('checkout/success', '', 'SSL'));
        }
    }



    protected function common($url, $post)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
        $response = curl_exec($ch);
        curl_close($ch);
        return json_decode($response);
    }
}



?>
