<?php

if (!class_exists('Sepal_Payment_Helper'))
{
	class Sepal_Payment_Helper
	{

		private $apiKey = '';
        private $apiUrl = 'https://sepal.ir/api';

		public function __construct($apiKey)
		{
			$this->apiKey = trim($apiKey);
		}

		public function paymentRequest($data)
		{
		    $apiParams = array(
		        'apiKey'    => $this->apiKey,
                'amount'      => $data['amount'],
                'callbackUrl'  => $data['return_url'],
                'description' => (isset($data['description'])?$data['description']:null),            
                'invoiceNumber'    => (isset($data['order_id'])?$data['order_id']:null),
                'payerName'       => (isset($data['payer']['name'])?$data['payer']['name']:null)
            );
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, $this->apiUrl.'/request.json');
            curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($apiParams));
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            $response = json_decode(curl_exec($curl));
            $error = curl_error($curl);
            curl_close($curl);

			if ($error) {
				$this->error = 'خطا در اتصال به درگاه پرداخت سپال : ' . $error;
				return false;
			}
			if (isset($response->status) && $response->status == 1){
                $this->gatewayUrl = 'https://sepal.ir/payment/'.$response->paymentNumber;
                return $response->paymentNumber;
            }else{
			    $this->error = isset($response->message) ? $response->message : 'خطا در اتصال به درگاه پرداخت سپال';
			    return false;
            }
			return false;
		}

		public function redirect($auto_connect = false)
		{
			if ($auto_connect === true) @header('location: '.$this->gatewayUrl);
			echo ('<form name="frmSepalPayment" method="get" action="'.$this->gatewayUrl.'"><input type="submit" value="پرداخت" /></form>');
			if ($auto_connect === true) echo ('<script>document.frmSepalPayment.submit();</script>');
		}

		public function paymentVerify($params, $amount)
		{
			if ($params['status'] == '1') {
			    $apiParams = array(
			        'apiKey' => $this->apiKey,
			        'paymentNumber' => $params['paymentNumber'],
                );
                $curl = curl_init();
                curl_setopt($curl, CURLOPT_URL, $this->apiUrl.'/verify.json');
                curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type' => 'application/json'));
                curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode( $apiParams ));
                curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                $response = json_decode(curl_exec($curl));
                $error = curl_error($curl);
                curl_close($curl);

                if ($error) {
                    $this->error = 'خطا در اتصال به درگاه پرداخت سپال : ' . $error;
                    return false;
                }
                if (isset($response->status) && $response->status == 1){
                    $this->txn_id     = $params['paymentNumber'];
                    $this->payment_id = $params['paymentNumber'];
                    return true;
                }else{
                    $this->error = isset($response->message) ? $response->message : 'خطا در دریافت تاییدیه تراکنش';
                    return false;
                }
			} else {
				$this->error = 'پرداخت انجام نشد';
			}
			return false;
		}

	}
}

?>