<?php

/*
Plugin Name: درگاه پرداخت سپال برای افزونه EDD وردپرس
Plugin URI: https://sepal.ir
Description: <b> درگاه پرداخت سپال برای افزونه EDD وردپرس </b>
Version: 1.0
Author: سپال
Author URI: https://sepal.ir
 */

function edd_add_gateway_sepal($gateways)
{
	return array_merge($gateways, array(
				'sepal' => array(
					'admin_label'    => 'سپال',
					'checkout_label' => 'سپال',
					'supports'       => array('buy_now')
				)
			)
		);
}
add_filter('edd_payment_gateways', 'edd_add_gateway_sepal');

function edd_send_to_gateway_sepal($purchase_data)
{
	global $edd_options;
	$payment_data = array(
			'price'        => $purchase_data['price'], 
			'date'         => $purchase_data['date'], 
			'user_email'   => $purchase_data['post_data']['edd_email'],
			'purchase_key' => $purchase_data['purchase_key'],
			'currency'     => $edd_options['currency'],
			'downloads'    => $purchase_data['downloads'],
			'cart_details' => $purchase_data['cart_details'],
			'user_info'    => $purchase_data['user_info'],
			'status'       => 'pending'
		);
	if ($payment = edd_insert_payment($payment_data))
	{
		require_once(dirname(__FILE__) . '/sepal_payment_helper.class.php');
		$p = new Sepal_Payment_Helper($edd_options['sepal_apiKey']);
		$r = $p->paymentRequest(array(
				'amount'      => intval(ceil($purchase_data['price'])),
				'order_id'    => $payment,
				'reserve_id'  => $purchase_data['purchase_key'],
				'description' => 'EDD-Order#'.$payment,
				'return_url'  => add_query_arg(array('gateway' => 'sepal', 'succ' => 'Y', 'paymentId' => $payment), get_permalink($edd_options['success_page'])),
				'payer'       => array(
				'name'        => @$purchase_data['post_data']['edd_first'].' '.@$purchase_data['post_data']['edd_last'],
				'email'       => @$purchase_data['post_data']['edd_email'],
				'mobile'      => @$purchase_data['post_data']['edd_phone'],
			)));
		if ($r)
		{
			$p->redirect(true);
		}
		else
		{
			echo $p->error;
		}
		exit;
	}
	else
	{
		edd_send_back_to_checkout('?payment-mode='.$purchase_data['post_data']['edd-gateway']);
	}
}
add_action('edd_gateway_sepal', 'edd_send_to_gateway_sepal');

function edd_gateway_sepal_verify()
{
	global $edd_options;
	if (isset($_GET['gateway'],$_GET['succ'],$_GET['paymentId']) && $_GET['gateway'] == 'sepal' && $_GET['succ'] == 'Y')
	{
		require_once(dirname(__FILE__) . '/sepal_payment_helper.class.php');
		$p = new Sepal_Payment_Helper($edd_options['sepal_apiKey']);
		$r = $p->paymentVerify($_POST, intval(ceil(edd_get_payment_amount($_GET['paymentId']))));
		if ($r)
		{
			$message = "Payment Completed. PaymentReferenceId : {$p->txn_id}";
			edd_update_payment_status($_GET['paymentId'], 'publish');
			edd_insert_payment_note($_GET['paymentId'], $message);
			edd_send_to_success_page();
			edd_empty_cart();
			echo '<script type="text/javascript">alert("'.$message.'");</script>';
		}
		else
		{
			edd_insert_payment_note($_GET['paymentId'], 'Error : '.$p->error);
			edd_insert_payment_note($_GET['paymentId'], 'Error : '.print_r($p,1));
			edd_update_payment_status($_GET['paymentId'], 'failed');
			wp_redirect( get_permalink($edd_options['failure_page']) );
			exit;
		}
	}
}
add_action('init', 'edd_gateway_sepal_verify');

function edd_gateway_sepal_setting($settings)
{
	return array_merge( $settings, array (
				array (
					'id'   => 'sepal_setting',
					'name' => 'sepal Setting',
					'desc' => 'sepal Setting',
					'type' => 'header'
				),
				array (
					'id'   => 'sepal_apiKey',
					'name' => 'sepal apiKey',
					'desc' => 'sepal apiKey',
					'type' => 'text',
					'size' => 'regular'
				),
			)
		);
}
add_filter('edd_settings_gateways', 'edd_gateway_sepal_setting');

function edd_sepal_cc_form_filter(){}
add_filter( 'edd_sepal_cc_form', 'edd_sepal_cc_form_filter' );

?>