﻿<?php
/*
 * Plugin Name:       افزونه درگاه پرداخت Paid Memberships Pro برای سپال
 * Plugin URI:        https://sepal.ir/
 * Description:       این افزونه به صورت اختصاصی توسط سپال پیاده سازی شده است!
 * Version:           1.0
 * Author:            سپال
 * Author URI:        https://sepal.ir/
 * WP tested up to:   5.7.2
 * Requires PHP:      7.1
 * License:           GPLv3
*/
defined('ABSPATH') || exit;
function sepal_Pmpro_Activate() {
    global $wpdb;
    $table_names = ['pmpro_discount_codes', 'pmpro_discount_codes_levels', 'pmpro_discount_codes_uses', 'pmpro_memberships_categories', 'pmpro_memberships_pages', 'pmpro_memberships_users', 'pmpro_membership_levelmeta', 'pmpro_membership_levels', 'pmpro_membership_orders', ];
    foreach ($table_names as $table_name) {
        $table_name = $wpdb->prefix . $table_name;
        if ($wpdb->get_var("show tables like '$table_name'") == $table_name) $wpdb->query("ALTER TABLE $table_name CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;");
    }
}
add_action('plugins_loaded', 'load_sepal_pmpro_class', 11);
add_action('plugins_loaded', ['PMProGateway_sepal', 'init'], 12);
register_activation_hook(__FILE__, 'sepal_Pmpro_Activate');
function load_sepal_pmpro_class() {
    if (class_exists('PMProGateway')) {
        class PMProGateway_sepal extends PMProGateway {
            public function __construct($gateway = NULL) {
                $this->gateway = $gateway;
                return $this->gateway;
            }
            public static function init() {
                add_filter('pmpro_gateways', [__CLASS__, 'pmpro_gateways', ]);
                add_filter('pmpro_payment_options', [__CLASS__, 'pmpro_payment_options', ]);
                add_filter('pmpro_payment_option_fields', [__CLASS__, 'pmpro_payment_option_fields', ], 10, 2);
                add_filter('pmpro_currencies', [__CLASS__, 'pmpro_currencies', ]);
                $gateway = pmpro_getOption('gateway');
                if ($gateway == 'sepal') {
                    add_filter('pmpro_checkout_before_change_membership_level', [__CLASS__, 'pmpro_checkout_before_change_membership_level', ], 10, 2);
                    add_filter('pmpro_include_billing_address_fields', '__return_false');
                    add_filter('pmpro_include_payment_information_fields', '__return_false');
                    add_filter('pmpro_required_billing_fields', [__CLASS__, 'pmpro_required_billing_fields', ]);
                }
                add_action('wp_ajax_nopriv_sepal-ins', [__CLASS__, 'pmpro_wp_ajax_sepal_ins', ]);
                add_action('wp_ajax_sepal-ins', [__CLASS__, 'pmpro_wp_ajax_sepal_ins', ]);
                add_action('pmpro_checkout_after_form', [__CLASS__, 'pmpro_checkout_after_form', ]);
                add_action('pmpro_invoice_bullets_bottom', [__CLASS__, 'pmpro_invoice_bullets_bottom', ]);
            }
            public static function SendRequestTosepal($action, $params) {
                try {
                    $ch = curl_init('https://sepal.ir/api/' . $action . '.json');
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                        'Content-Type' => 'application/json'
                    ));
                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                        'Content-Type: application/json',
                        'Content-Length: ' . strlen($params)
                    ));
                    $result = curl_exec($ch);
                    return json_decode($result, true);
                }
                catch(Exception $ex) {
                    return false;
                }
            }
            public static function pmpro_currencies($currencies) {
                $currencies['IRT'] = array(
                    'name' => __('Iranian Toman', 'sepal-paid-memberships-pro') ,
                    'symbol' => __('Toman', 'sepal-paid-memberships-pro') ,
                    'position' => 'right',
                );
                $currencies['IRR'] = array(
                    'name' => __('Iranian Rial', 'sepal-paid-memberships-pro') ,
                    'symbol' => ' &#65020;',
                    'position' => 'right',
                );
                return $currencies;
            }
            public static function pmpro_gateways($gateways) {
                if (empty($gateways['sepal'])) $gateways['sepal'] = 'sepal';
                return $gateways;
            }
            public static function getGatewayOptions() {
                return ['sepal_api_key', 'currency', 'tax_rate'];
            }
            public static function pmpro_payment_options($options) {
                $sepal_options = self::getGatewayOptions();
                return array_merge($sepal_options, $options);
            }
            public static function pmpro_required_billing_fields($fields) {
                unset($fields['bfirstname']);
                unset($fields['blastname']);
                unset($fields['baddress1']);
                unset($fields['bcity']);
                unset($fields['bstate']);
                unset($fields['bzipcode']);
                unset($fields['bphone']);
                unset($fields['bemail']);
                unset($fields['bcountry']);
                unset($fields['CardType']);
                unset($fields['AccountNumber']);
                unset($fields['ExpirationMonth']);
                unset($fields['ExpirationYear']);
                unset($fields['CVV']);
                return $fields;
            }
            public static function pmpro_payment_option_fields($values, $gateway) { ?>
                <tr class="pmpro_settings_divider gateway gateway_sepal"
                    <?php if ($gateway != 'sepal'): ?>
                        style="display: none;"
                    <?php                endif; ?>
                >
                    <td colspan="2">
                        <hr>
                        <h3>تنظیمات سپال</h3>
                    </td>
                </tr>
                <tr class="gateway gateway_sepal"
                    <?php if ($gateway != 'sepal'): ?>
                        style="display: none;"
                    <?php endif; ?>
                >
                    <th scope="row" valign="top">
                        <label for="sepal_api_key"><?php _e('API Key', 'sepal-paid-memberships-pro'); ?> :</label>
                    </th>
                    <td>
                        <input type="text" id="sepal_api_key"
                               name="sepal_api_key" size="60"
                               value="<?php echo esc_attr($values['sepal_api_key']); ?>"
                        />
                    </td>
                </tr>
                <script>
                    setTimeout(function(){
                        pmpro_changeGateway(jQuery('#gateway').val())
                    }, 100);
                </script>
                <?php
            }
            public static function pmpro_checkout_after_form() {
                print '<style>
                    .sepal-pmpro-logo{
                        margin: calc(-1em - 44px) 0 calc(1.5em + 44px) 0;
                        display: block;
                    }
                </style>';

                if (!empty($_GET['sepal_message'])) {
                    print '<div class="pmpro_error pmpro_message" style="text-align: center;">' . sanitize_text_field($_GET['sepal_message']) . '</div>';
                }
            }
            public static function pmpro_invoice_bullets_bottom() {
                if (!empty($_GET['sepal_message'])) print '<div class="pmpro_success pmpro_message sepal-success-message" style="text-align: center;margin: 30px 0 0 0;">' . sanitize_text_field($_GET['sepal_message']) . '</div>';
            }
            public static function pmpro_checkout_before_change_membership_level($user_id, $morder) {
                global $wpdb, $discount_code_id;
                if (empty($morder)) return;
                $morder->user_id = $user_id;
                $morder->saveOrder();
                //if (!empty($discount_code_id)) $wpdb->query("INSERT INTO $wpdb->pmpro_discount_codes_uses (code_id, user_id, order_id, timestamp) VALUES('" . $discount_code_id . "', '" . $user_id . "', '" . $morder->id . "', now())");
                $gtw_env = pmpro_getOption('gateway_environment');
                $api_key = pmpro_getOption('sepal_api_key');
                if ($gtw_env == '' || $gtw_env == 'sandbox') $sandbox = 1;
                else $sandbox = 0;
                $order_id = $morder->code;
                $callback = admin_url('admin-ajax.php') . '?action=sepal-ins&oid=' . $order_id;

                global $pmpro_currency;
                $amount = intval($morder->subtotal);
                if ($pmpro_currency == 'IRT') $amount *= 10;

                $data = ['apiKey' => $api_key, 'amount' => $amount, 'callbackUrl' => $callback, 'invoiceNumber' => $order_id, 'description' => "", ];
                $result = self::SendRequestTosepal('request', json_encode($data));

                if ($result === false) {
                    echo 'cURL Error';
                }
                else if ($result['status']) {
                    $paymentUrl = 'https://sepal.ir/payment/' . $result['paymentNumber'];
                    wp_redirect($paymentUrl);
                    exit;
                }
                else {
                    $Message = ' تراکنش ناموفق بود- کد خطا : ' . $result['message'];
                    $Fault = $result['message'];
                }

                if ($Message) {
                    $morder->status = 'error';
                    $morder->notes = $Message;
                    $morder->saveOrder();
                    $redirect = pmpro_url('checkout', '?level=' . $morder
                        ->membership_level->id . '&sepal_message=' . $Message);
                    wp_redirect($redirect);
                    exit;
                }
            }
            public static function pmpro_wp_ajax_sepal_ins() {
                if (!isset($_GET['oid']) || empty($_GET['oid'])) {
                    $redirect = pmpro_url('checkout', '?sepal_message=' . __('The oid parameter is not set.', 'sepal-paid-memberships-pro'));
                    wp_redirect($redirect);
                    exit;
                }

                $oid = sanitize_text_field($_GET['oid']);
                $morder = NULL;
                try {
                    $morder = new MemberOrder($oid);
                    $morder->getMembershipLevel();
                }
                catch(Exception $exception) {
                    $redirect = pmpro_url('checkout', '?sepal_message=' . __('The oid parameter is not correct.', 'sepal-paid-memberships-pro'));
                    wp_redirect($redirect);
                    exit;
                }

                $id = !empty($_POST['id']) ? sanitize_text_field($_POST['id']) : (!empty($_GET['id']) ? sanitize_text_field($_GET['id']) : NULL);

                if (isset($_POST['status']) && $_POST['status'] == 1) {

                    $gtw_env = pmpro_getOption('gateway_environment');
                    $api_key = pmpro_getOption('sepal_api_key');

                    $paymentNumber = $_POST['paymentNumber'];
                    $data = array(
                        'apiKey' => $api_key,
                        'paymentNumber' => $paymentNumber,
                    );
                    $result = self::SendRequestTosepal('verify', json_encode($data));

                    if ($result['status']) {
                        $Status = 'completed';
                        $Fault = '';
                        $Message = '';
                    }
                    else {
                        $Status = 'failed';
                        $Fault = $result['message'];
                        $Message = 'تراکنش ناموفق بود';
                    }
                }

                if ($Status === 'completed' && isset($paymentNumber) && $paymentNumber !== 0) {
                    if (self::do_level_up($morder, $id)) {
                        $note = "پرداخت شما با موفقیت ثبت شد! شماره پیگیری: $paymentNumber";
                        $morder->notes = $note . "<br>data: " . print_r($result, true);
                        $morder->saveOrder();

                        $redirect = pmpro_url('confirmation', '?level=' . $morder
                            ->membership_level->id . '&sepal_message=' . $note);
                        wp_redirect($redirect);
                        exit;
                    }
                    else {
                        $note = sprintf(__("An Error accrued doing level up. track id: %s, order id: %s", "sepal-paid-memberships-pro") , $result->track_id, $order_id);
                        $morder->notes = $note;
                        $morder->status = 'error';
                        $morder->saveOrder();

                        $redirect = pmpro_url('checkout', '?level=' . $morder
                            ->membership_level->id . '&sepal_message=' . $note);
                        wp_redirect($redirect);
                        exit;
                    }
                }

                $morder->notes = $note = "خطایی رخ داده است!";
                $morder->status = 'error';
                $morder->saveOrder();

                $redirect = pmpro_url('checkout', '?level=' . $morder
                    ->membership_level->id . '&sepal_message=' . $note);
                wp_redirect($redirect);
                exit;
            }
            public static function do_level_up(&$morder, $txn_id) {
                global $wpdb;
                $morder->membership_level = apply_filters('pmpro_inshandler_level', $morder->membership_level, $morder->user_id);
                if (!empty($morder
                    ->membership_level
                    ->expiration_number)) {
                    $enddate = "'" . date('Y-m-d', strtotime('+ ' . $morder
                        ->membership_level->expiration_number . ' ' . $morder
                        ->membership_level->expiration_period, current_time('timestamp'))) . "'";
                }
                else {
                    $enddate = 'NULL';
                }
                $morder->getDiscountCode();
                if (!empty($morder->discount_code)) {
                    $morder->getMembershipLevel(true);
                    $discount_code_id = $morder
                        ->discount_code->id;
                }
                else {
                    $discount_code_id = '';
                }
                $startdate = apply_filters('pmpro_checkout_start_date', "'" . current_time('mysql') . "'", $morder->user_id, $morder->membership_level);
                $custom_level = ['user_id' => $morder->user_id, 'membership_id' => $morder
                    ->membership_level->id, 'code_id' => $discount_code_id, 'initial_payment' => $morder
                    ->membership_level->initial_payment, 'billing_amount' => $morder
                    ->membership_level->billing_amount, 'cycle_number' => $morder
                    ->membership_level->cycle_number, 'cycle_period' => $morder
                    ->membership_level->cycle_period, 'billing_limit' => $morder
                    ->membership_level->billing_limit, 'trial_amount' => $morder
                    ->membership_level->trial_amount, 'trial_limit' => $morder
                    ->membership_level->trial_limit, 'startdate' => $startdate, 'enddate' => $enddate, ];

                global $pmpro_error;
                if (!empty($pmpro_error)) {
                    echo $pmpro_error;
                    inslog($pmpro_error);
                }

                if (pmpro_changeMembershipLevel($custom_level, $morder->user_id) !== false) {
                    $morder->status = 'success';
                    $morder->payment_transaction_id = $txn_id;
                    $morder->subscription_transaction_id = '';
                    $morder->saveOrder();
                    if (!empty($discount_code) && !empty($use_discount_code)) $wpdb->query("INSERT INTO $wpdb->pmpro_discount_codes_uses (code_id, user_id, order_id, timestamp) VALUES('" . $discount_code_id . "', '" . $morder->user_id . "', '" . $morder->id . "', '" . current_time('mysql') . "')");
                    if (!empty($_POST['first_name'])) {
                        $old_firstname = get_user_meta($morder->user_id, 'first_name', true);
                        if (!empty($old_firstname)) update_user_meta($morder->user_id, 'first_name', sanitize_text_field($_POST['first_name']));
                    }
                    if (!empty($_POST['last_name'])) {
                        $old_lastname = get_user_meta($morder->user_id, 'last_name', true);
                        if (!empty($old_lastname)) update_user_meta($morder->user_id, 'last_name', sanitize_text_field($_POST['last_name']));
                    }
                    if (version_compare(PMPRO_VERSION, '2.0', '>=')) do_action('pmpro_after_checkout', $morder->user_id, $morder);
                    else do_action('pmpro_after_checkout', $morder->user_id);
                    if (!empty($morder)) $invoice = new MemberOrder($morder->id);
                    else $invoice = NULL;

                    $user = get_userdata(intval($morder->user_id));
                    if (empty($user)) {
                        return false;
                    }

                    $user->membership_level = $morder->membership_level; //make sure they have the right level info
                    $pmproemail = new PMProEmail();
                    $pmproemail->sendCheckoutEmail($user, $invoice);
                    $pmproemail = new PMProEmail();
                    $pmproemail->sendCheckoutAdminEmail($user, $invoice);

                    return true;
                }
                else {
                    return false;
                }
            }
            private static function call_gateway_endpoint($url, $args) {
                $number_of_connection_tries = 4;
                while ($number_of_connection_tries) {
                    $response = wp_safe_remote_post($url, $args);
                    if (is_wp_error($response)) {
                        $number_of_connection_tries--;
                        continue;
                    }
                    else {
                        break;
                    }
                }
                return $response;
            }
        }
    }
}