<?php
defined( 'ABSPATH' ) || exit;
if ( ! class_exists( 'LP_Gateway_Sepal' ) ) {
	class LP_Gateway_Sepal extends LP_Gateway_Abstract {
		private $form_data = array();
		private $wsdl = 'https://sepal.ir/api/request.json';
		private $startPay = 'https://sepal.ir/payment/';
		private $verifyUrl = 'https://sepal.ir/api/verify.json';
		private $merchantID = null;
		protected $settings = null;
		protected $order = null;
		protected $posted = null;

		public function __construct() {

			$this->id = 'sepal';

			$this->method_title       = __( 'سپال', 'sepal-learnpress' );;
			$this->method_description = __( 'با سپال پرداخت کنید.', 'sepal-learnpress' );
			$this->icon               = '';
			$this->title       = LP()->settings->get( "{$this->id}.title", $this->method_title );
			$this->description = LP()->settings->get( "{$this->id}.description", $this->method_description );
			$settings = LP()->settings;
			
			if ( $settings->get( "{$this->id}.enable" ) ) {
				$this->settings                = array();
				$this->settings['merchant_id'] = $settings->get( "{$this->id}.merchant_id" );
				
			}
			
			$this->merchantID = $this->settings['merchant_id'];
			if ( did_action( 'learn_press/sepal-add-on/loaded' ) ) {
				return;
			}
			add_filter( 'learn-press/payment-gateway/' . $this->id . '/available', array(
				$this,
				'sepal_available'
			), 10, 2 );
			do_action( 'learn_press/sepal-add-on/loaded' );
			parent::__construct();
			if ( did_action( 'init' ) ) {
				
				$this->register_web_hook();
			} else {
				
				add_action( 'init', array( $this, 'register_web_hook' ) );
			}
			add_action( 'learn_press_web_hooks_processed', array( $this, 'web_hook_process_sepal' ) );
			add_action("learn-press/before-checkout-order-review", array( $this, 'error_message' ));
		}
		public function register_web_hook() {
			
			learn_press_register_web_hook( 'sepal', 'learn_press_sepal' );
			
		}
		
		public function get_settings() {
			
			return apply_filters( 'learn-press/gateway-payment/sepal/settings',
				array(
					array(
						'title'   => __( 'فعال سازی', 'sepal-learnpress' ),
						'id'      => '[enable]',
						'default' => 'no',
						'type'    => 'yes-no'
					),
					array(
						'type'       => 'text',
						'title'      => __( 'نام درگاه', 'sepal-learnpress' ),
						'default'    => __( 'سپال', 'sepal-learnpress' ),
						'id'         => '[title]',
						'class'      => 'regular-text',
						'visibility' => array(
							'state'       => 'show',
							'conditional' => array(
								array(
									'field'   => '[enable]',
									'compare' => '=',
									'value'   => 'yes'
								)
							)
						)
					),
					array(
						'type'       => 'textarea',
						'title'      => __( 'توضیحات درگاه', 'sepal-learnpress' ),
						'default'    => __( 'پرداخت امن توسط درگاه سپال', 'sepal-learnpress' ),
						'id'         => '[description]',
						'editor'     => array(
							'textarea_rows' => 5
						),
						'css'        => 'height: 100px;',
						'visibility' => array(
							'state'       => 'show',
							'conditional' => array(
								array(
									'field'   => '[enable]',
									'compare' => '=',
									'value'   => 'yes'
								)
							)
						)
					),
					array(
						'title'      => __( 'پین درگاه', 'sepal-learnpress' ),
						'id'         => '[merchant_id]',
						'type'       => 'text',
						'visibility' => array(
							'state'       => 'show',
							'conditional' => array(
								array(
									'field'   => '[enable]',
									'compare' => '=',
									'value'   => 'yes'
								)
							)
						)
					)
				)
			);
		}

		public function get_payment_form() {
		
			ob_start();
			$template = learn_press_locate_template( 'form.php', learn_press_template_path() . '/addons/sepal-payment/', LP_ADDON_SEPAL_PAYMENT_TEMPLATE );
			
			include $template;
			
			return ob_get_clean();
		}

		public function error_message() {
		
			if(!isset($_SESSION))
				@session_start();
			if(isset($_SESSION['sepal_error']) && intval($_SESSION['sepal_error']) === 1) {
				
				$_SESSION['sepal_error'] = 0;
				$template = learn_press_locate_template( 'payment-error.php', learn_press_template_path() . '/addons/sepal-payment/', LP_ADDON_SEPAL_PAYMENT_TEMPLATE );
				include $template;
			}
		}
		public function get_icon() {
		
			if ( empty( $this->icon ) ) {

				$this->icon = LP_ADDON_SEPAL_PAYMENT_URL . 'assets/images/sepal.png';
			}
			return parent::get_icon();
		}
		public function sepal_available() {
			
			if ( LP()->settings->get( "{$this->id}.enable" ) != 'yes' ) {
				return false;
			}
			return true;
		}
		public function get_form_data() {
		
		
			if ( $this->order ) {
				$user            = learn_press_get_current_user();
				$currency_code = learn_press_get_currency();
				if ($currency_code == 'IRR') {
					$amount = $this->order->order_total;
				} else {
					$amount = $this->order->order_total ;
				}
				$this->form_data = array(
					'amount'      => $amount,
					'currency'    => strtolower( learn_press_get_currency() ),
					'token'       => $this->token,
					'description' => sprintf( __("ایمیل خریدار %s","sepal-learnpress"), $user->get_data( 'email' ) ),
					'customer'    => array(
						'name'          => $user->get_data( 'display_name' ),
						'billing_email' => $user->get_data( 'email' ),
					),
					'errors'      => isset( $this->posted['form_errors'] ) ? $this->posted['form_errors'] : ''
				);
			}
			return $this->form_data;
		}
		public function validate_fields() {
			
			$posted  = learn_press_get_request( 'learn-press-sepal' );
			$email   = !empty( $posted['email'] ) ? $posted['email'] : "";
			$mobile  = !empty( $posted['mobile'] ) ? $posted['mobile'] : "";
			$error_message = array();
			if ( !empty( $email ) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
				$error_message[] = __( 'ایمیل نامعتبر است.', 'sepal-learnpress' );
			}
			if ( !empty( $mobile ) && !preg_match("/^(09)(\d{9})$/", $mobile)) {
				$error_message[] = __( 'تلفن همراه نامعتبر است.', 'sepal-learnpress' );
			}
			if ( $error = sizeof( $error_message ) ) {
				throw new Exception( sprintf( '<div>%s</div>', join( '</div><div>', $error_message ) ), 8000 );
			}
			$this->posted = $posted;
			return $error ? false : true;
		}
		public function process_payment( $order ) {
			
			$this->order = learn_press_get_order( $order );
			$paymentNumber = $this->get_sepal_payment();
			$gateway_url = $this->startPay.$paymentNumber;
			$json = array(
				'result'   => $paymentNumber ? 'success' : 'fail',
				'redirect' => $paymentNumber ? $gateway_url : ''
			);
			return $json;
		}

		public function get_sepal_payment() {
			
			if ( $this->get_form_data() ) {
				$checkout = LP()->checkout();
				$data = [
					'amount' => $this->form_data['amount'],
					'apiKey' => $this->merchantID,
					'callbackUrl' => get_site_url() . '/?' . learn_press_get_web_hook( 'sepal' ) . '=1&order_id='.$this->order->get_id(),
					'invoiceNumber'=> $this->order->get_id(),
					'payerEmail' => @$this->posted['email'],
					'payerMobile' => @$this->posted['mobile'],
					'description' => $this->form_data['description'],
				];
				$result = $this->rest_payment_request($this->wsdl, json_encode($data));
				if ($result['status']) {
					return $result['paymentNumber'];
				} else {
					throw new exception($result['message']);
				}
			}
			return false;
		}
		public function web_hook_process_sepal() {
			$learn_press_sepal = sanitize_text_field($_REQUEST['learn_press_sepal']);
			$order_id = sanitize_text_field($_REQUEST['order_id']);
			if(isset($learn_press_sepal) && intval($learn_press_sepal) === 1) {
				$order = LP_Order::instance( $order_id );
				$currency_code = learn_press_get_currency();
				if ($currency_code == 'IRR') {
					$amount = $order->order_total;
				} else {
					$amount = $order->order_total;
				}
				$paymentNumber = sanitize_text_field($_REQUEST['paymentNumber']) ;
				$data = array(
						'paymentNumber'	=> $paymentNumber,
						'apiKey'		=> $this->merchantID,
					);
				$result = $this->rest_payment_verification($this->verifyUrl, json_encode($data));
				if ($result['status']) {
					$this->payment_status_completed($order);
					wp_redirect(esc_url( $this->get_return_url( $order ) ));
					exit();	
				}
				if (!isset($_SESSION)) {
					session_start();
					$_SESSION['sepal_error'] = 1;
					wp_redirect(esc_url( learn_press_get_page_link( 'checkout' ) ));
					exit();
				}
			}
		}

		public function rest_payment_request($url, $params)
		{
			$result = wp_remote_post($url, array(
				'method' => 'POST',
				'headers' => array(
					'Content-type: application/x-www-form-urlencoded',
					'Accept: application/json'
				),
				'timeout' => 30,
				'body' => $params
			));
			if (is_wp_error($result)) {
				return $result->get_error_message();
			} else {
				return json_decode(wp_remote_retrieve_body($result), true);
			}
		}
		
		public function rest_payment_verification($url,$params) {
			$result = wp_remote_post($url, array(
				'method' => 'POST',
				'headers' => array(
					'Content-type: application/x-www-form-urlencoded',
					'Accept: application/json'
				),
				'timeout' => 30,
				'body' => $params
			));
			if (is_wp_error($result)) {
				return $result->get_error_message();
			} else {
				return json_decode(wp_remote_retrieve_body($result), true);
			}
		}

		protected function payment_status_completed( $order ) {
			if ( $order->has_status( 'completed' ) ) {
				exit;
			}
			$this->payment_complete( $order, sanitize_text_field( $_REQUEST['paymentNumber'] ), __( 'Payment has been successfully completed', 'sepal-learnpress' ) );
			update_post_meta( $order->get_id(), '_sepal_paymentNumber', sanitize_text_field( $_POST['paymentNumber'] ) );
			update_post_meta( $order->get_id(), '_sepal_invoiceNumber', sanitize_text_field( $_REQUEST['invoiceNumber'] ) );
		}
		protected function payment_status_pending( $order ) {
			// why? $this->payment_status_completed( $order );
		}
		public function payment_complete( $order, $ref_num = '', $note = '' ) {
			$order->payment_complete( $ref_num );
		}
	}
}
