<?php

if (!class_exists('Sepal_Payment_Helper'))
{
	class Sepal_Payment_Helper
	{

		private $apiKey = '';
		private $apiUrl = 'https://sepal.ir/api';

		public function __construct($apiKey)
		{
			$this->apiKey = trim($apiKey);
		}

		public function paymentRequest($data)
		{
			$ch = curl_init($u = $this->apiUrl . '/request.json');
			curl_setopt($ch, CURLOPT_HTTPHEADER, $h = array('Content-Type: application/json'));
			curl_setopt($ch, CURLOPT_POSTFIELDS, $j = json_encode($p = array(
					'apiKey'      => $this->apiKey,
					'amount'      => $data['amount'],
					'callbackUrl'  => $data['return_url'],
					'description' => (isset($data['description'])?$data['description']:null),
					//'reserve_id'  => (isset($data['reserve_id'])?$data['reserve_id']:null),
					'invoiceNumber'    => (isset($data['order_id'])?$data['order_id']:time()),
					'payerName'       => (isset($data['payer']['name'])?$data['payer']['name']:null),
					'payerEmail'       => (isset($data['payer']['email'])?$data['payer']['email']:null),
					//'payerMobile'       => (isset($data['payer']['mobile'])?$data['payer']['mobile']:null),
				)));
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			$response = curl_exec($ch);
			$error = curl_error($ch);
			$info = curl_getinfo($ch);
			curl_close($ch);
			$result = json_decode($response);

			if ($error) {
				$this->error = 'خطا در اتصال به درگاه سپال : ' . $error;
			} elseif (!is_object($result)) {
				$this->error = 'خطا در ایجاد و ثبت پرداخت سپال : ' . json_last_error();
			} elseif (!isset($result->status)) {
				$this->error = 'خطا در اتصال به درگاه سپال';
				if (isset($result->message)) $this->error .= ' (' . $result->message . ')';
			} elseif (!$result->status) {
				$this->error = 'خطا در ثبت درخواست پرداخت سپال . متن خطا : ' . ' (' . $result->message . ')';
			} else {
				$this->gatewayUrl = 'https://sepal.ir/payment/'.$result->paymentNumber;
				return $result->paymentNumber;
			}
			return false;
		}

		public function redirect($auto_connect = false)
		{
			if ($auto_connect === true) @header('location: '.$this->gatewayUrl);
			echo ('<form name="frmSepalPayment" method="get" action="'.$this->gatewayUrl.'"><input type="submit" value="پرداخت" /></form>');
			if ($auto_connect === true) echo ('<script>document.Sepal.submit();</script>');
		}

		public function paymentVerify($params, $amount)
		{
			if ($params['status'] == '1') {
				$ch = curl_init($u = $this->apiUrl . '/verify.json');
				//curl_setopt($ch, CURLOPT_HTTPHEADER, $h = array('Content-Type: application/json', 'Content-Length: ' . strlen($j)));
				curl_setopt($ch, CURLOPT_HTTPHEADER, $h = array('Content-Type: application/json'));
				curl_setopt($ch, CURLOPT_POSTFIELDS, $j = json_encode($p = array(
						'apiKey' => $this->apiKey,
						//'amount'         => $amount,
						'paymentNumber' => $params['paymentNumber'],
						'invoiceNumber' => $params['invoiceNumber'],
					)));
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
				$response = curl_exec($ch);
				$error = curl_error($ch);
				$info = curl_getinfo($ch);
				curl_close($ch);
				$result = json_decode($response);
				if ($error) {
					$this->error = 'خطا در اتصال به سپال : ' . $error;
				} elseif (!is_object($result)) {
					$this->error = 'خطا در دریافت رسید پرداخت سپال : ' . json_last_error();
				} elseif (!isset($result->status)) {
					$this->error = 'خطا در اتصال به پرداخت سپال';
					if (isset($result->message)) $this->error .= ' (' . $result->message . ')';
				} elseif (!$result->status) {
					$this->error = 'خطا در تایید رسید پرداخت سپال . متن خطا : '. ' (' . $result->message . ')';
					$this->error = 'خطا در تایید رسید پرداخت سپال . متن خطا : '. ' (' . $result->message . ')';
				} else {
					$this->txn_id     = $params['paymentNumber'];
					//$this->amount     = $result->paid_amount;
					//$this->payment_id = $result->id;
					return true;
				}
			} else {
				$this->error = 'پرداخت انجام نشد';
			}
			return false;
		}

	}
}

?>