<?php

function sepal_config()
{
    return array(
        'FriendlyName' => array(
                'Type'  => 'System',
                'Value' => 'سپال'
            ),
        'apiKey' => array(
                'Type'         => 'text',
                'FriendlyName' => 'کلید API',
                'Size'         => '50'
            ),
        'currency' => array(
            'FriendlyName' => 'تنظیمات واحد پول',
            'Type' => 'dropdown',
            'Options' => array(
                'none' => 'بدون نیاز به تنظیمات',
                'whmcs' => 'تنظیم واحد پول ریال و تومان برروی WHMCS اعمال شده است',
                'irr' => 'واحد پول سایت ریال می باشد',
                'irt' => 'تنها از واحد پول تومان استفاده می کنم',
            ),
            'Description' => 'در صورتی که تنظیمات تبدیل واحد پول برروی سیستم اعمال نشده است یکی از گزینه های روبه رو را انتخاب و یک فاکتور را جهت پرداخت تست نمایید',
        )
    );
}

function sepal_link($params)
{
    $systemUrl = $params['systemurl'];

    $invoiceId = $params['invoiceid'];
    $description = $params["description"];
    $amount = $params['amount'];
    $currencyCode = $params['currency'];
    $phone = $params['clientdetails']['phonenumber'];
    $firstname = $params['clientdetails']['firstname'];
    $lastname = $params['clientdetails']['lastname'];
    $email = $params['clientdetails']['email'];

    if(substr($systemUrl, -1) != '/')
    {
        $systemUrl = $systemUrl.'/';
    }
    $url = $systemUrl . 'modules/gateways/sepal/connect.php';
    $postfields = array();
    $postfields['invoice_id'] = $invoiceId;
    $postfields['description'] = 'فاکتور شماره '.$invoiceId;
    $postfields['amount'] = $amount;
    $postfields['currency'] = $currencyCode;
    $postfields['first_name'] = $firstname;
    $postfields['last_name'] = $lastname;
    $postfields['email'] = $email;
    $postfields['phone'] = $phone;
    $postfields['callback_url'] = $systemUrl . 'modules/gateways/callback/sepal.php';

    $htmlOutput = '<form method="post" action="' . $url . '">';
    foreach ($postfields as $k => $v) {
        $htmlOutput .= '<input type="hidden" name="' . $k . '" value="' . urlencode($v) . '" />';
    }
    $htmlOutput .= '<input class="btn btn-primary" type="submit" value="پرداخت" />';
    $htmlOutput .= '</form>';
    return $htmlOutput;
}

?>